import numpy as np
import os
import pandas as pd

def spectral_calibration():
    items = os.listdir(".")
    for names in items:
        if names.endswith("parameters_cal.txt"):
            filename = names

    ref = np.genfromtxt(filename, delimiter='\t')
    wavelength = (ref[0, :])
    reciprocal = (ref[1, :])



    P_freq2wave = np.polyfit(reciprocal, 1/wavelength, 7);
    P_wave2freq = np.polyfit(1/wavelength, reciprocal, 7);

    return P_freq2wave, P_wave2freq


